begin
 ;AOD interpolation from WRF-Chem
 path="/home/user/chensy3/csr4/zhangyue/wrfdata/wrfout/ETL_data/AOD_data/2020-03/"
  filename="wrfout_DayilAOD_2020_03_*.nc"
  outfiles=systemfunc("ls " +path+filename)
  f=addfiles(outfiles+".nc","r")
  ListSetType(f,"join")
  var = wrf_user_getvar(f(:),"AOD",-1)
  printVarSummary(var)
  var_month=dim_avg_n(var,1)
  printVarSummary(var_month)  


  geof1  = addfile("/home/user/chensy3/data/zhangyue/WPSV391_2020-03/geo_em.d01.nc","r")
  lat2d = geof1->XLAT_M(0,:,:)
  lon2d = geof1->XLONG_M(0,:,:)
  lat1d = lat2d(:,0)
  lon1d = lon2d(0,:)
 
 aod_chem = new((/7,38,49/),float)
 do i=0,6

  AOD_avg=var_month(i,:,:)
  AOD_avg!0="lat2d"
  AOD_avg!1="lon2d"
  AOD_avg@lat2d = lat2d  
  AOD_avg@lon2d = lon2d
  AOD_avg2 = rcm2rgrid_Wrap(lat2d,lon2d,AOD_avg,lat1d,lon1d,0)
  AOD_avg2!0="lat"
  AOD_avg2!1="lon"

  printVarSummary(AOD_avg2)
  AOD_zuizhong=AOD_avg2({13:51},{78:127})
  printVarSummary(AOD_zuizhong)

  lon_def=fspan(78, 127, 49)
  lat_def=fspan(13,51,38)
  lon_aod=AOD_zuizhong&lon
  lat_aod=AOD_zuizhong&lat
  aod_chem1=linint2_Wrap(lon_aod, lat_aod, AOD_zuizhong, True, lon_def, lat_def, 0)
  aod_chem1!0="lat"
  aod_chem1!1="lon"
  aod_chem1&lon@units="degrees_east"
  aod_chem1&lat@units="degrees_north"
  printVarSummary(aod_chem1)
  aod_chem(i,:,:)=aod_chem1
  delete([/AOD_avg,AOD_avg2,AOD_zuizhong,aod_chem1,lon_aod,lat_aod,lon_def,lat_def/])

end do
  aod_chem!0="test"
  aod_chem!1="lat"
  aod_chem!2="lon"
  aod_chem&lat=fspan(13,51,38)
  aod_chem&lon=fspan(78, 127, 49)
  aod_chem&lon@units="degrees_east"
  aod_chem&lat@units="degrees_north"

  printVarSummary(aod_chem)

;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  aa=addfile("./MISR_AOD_2020_03.nc", "r")
  AOD=aa->AOD
  printVarSummary(AOD)
  
  lon_aod=AOD&lon
  lat_aod=AOD&lat
  
  lon_def=fspan(78, 127, 49)
  lat_def=fspan(13,51,38)
  
  aod_misr=linint2_Wrap(lon_aod, lat_aod, AOD, True, lon_def, lat_def, 0)
  aod_misr!0="lat"
  aod_misr!1="lon"
  aod_misr&lon@units="degrees_east"
  aod_misr&lat@units="degrees_north"
  printVarSummary(aod_misr)
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::;;  
  wks=gsn_open_wks("png", "Fig5_x_bar")
  rs=True
  rs@gsnAddCyclic=False
  rs@gsnMaximize=True
  rs@gsnFrame=False
  rs@gsnDraw=False
  res=rs
  res@cnFillOn=True
  res@cnLinesOn=False
  res@mpMinLatF             = 36;13  36针对MISR缩小后的区域
  res@mpMaxLatF             = 51
  res@mpMinLonF             = 78;2.6028
  res@mpMaxLonF             = 114;127;133.397  ；114是针对MISR缩小后的区域
  res@tmYROn                =False
  res@tmXTOn                =False
  res@gsnLeftString         = ""
  res@gsnRightString        = ""

  res@cnFillPalette         = "MPL_rainbow";"temp_diff_18lev";"WhiteBlueGreenYellowRed"
  res@lbLabelBarOn=True
  res@pmLabelBarOrthogonalPosF=0.4
  res@lbBoxSeparatorLinesOn=False
  res@cnLineLabelsOn=False

  res@cnLevelSelectionMode = "ManualLevels" 
  res@cnMaxLevelValF = 0.04;0.7;    ;misr缩小区域之后的范围是0-0.7;0.035
  res@cnMinLevelValF = -0.04;0;
  res@cnLevelSpacingF      = 0.01;0.035;         ; NCL chose 4.0
  

  res@mpDataSetName  = "/home/data/data-CSR4/chenyu/mapdata/Earth..4"
  res@mpDataBaseVersion="MediumRes"
  res@mpOutlineOn = True
  res@mpAreaMaskingOn       = True
  res@mpNationalLineColor        = "black"
  res@mpCountyLineColor      = "black"
  res@mpLandFillColor               ="white"
  res@mpGeophysicalLineThicknessF =1.5
  res@mpNationalLineThicknessF=1.5
  res@mpOceanFillColor              = "white"
  res@mpInlandWaterFillColor        = "white"
  res@tmXBLabelFontHeightF=0.025
  res@tmYLLabelFontHeightF=0.025
  res@tmBorderThicknessF=3

;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  resd=res
  resd@cnFillPalette="temp_19lev";"BlueDarkRed18";用该色板填色
  resd@cnLevelSelectionMode ="ExplicitLevels"
  Levels = (/-0.04,-0.03,-0.02,-0.01,0.01,0.02,0.03,0.04/)
  resd@cnLevels = Levels
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  
  do j=0,6
  aod_chem(j,:,:)=aod_chem(j,:,:)+aod_misr-aod_misr
  end do
  
  aod_dif2=aod_chem(2,:,:)-aod_chem(1,:,:)
  aod_dif3=aod_chem(3,:,:)-aod_chem(1,:,:)
  aod_dif4=aod_chem(4,:,:)-aod_chem(1,:,:)
  aod_dif5=aod_chem(5,:,:)-aod_chem(1,:,:)
  aod_dif6=aod_chem(6,:,:)-aod_chem(1,:,:)

  copy_VarMeta(aod_misr, aod_dif2)
  copy_VarMeta(aod_misr, aod_dif3)
  copy_VarMeta(aod_misr, aod_dif4)
  copy_VarMeta(aod_misr, aod_dif5)
  copy_VarMeta(aod_misr, aod_dif6) 
 
  plot = new (1, graphic )
  
  ;plot(0)=gsn_csm_contour_map(wks, aod_misr, res)
  ;plot(1)=gsn_csm_contour_map(wks, aod_modis, res)
  ;plot(0)=gsn_csm_contour_map(wks, aod_chem(1,:,:), res)
  ;plot(0)=gsn_csm_contour_map(wks, aod_chem(0,:,:), res)
  
  ;plot(0)=gsn_csm_contour_map(wks, aod_dif2, resd)
  ;plot(0)=gsn_csm_contour_map(wks, aod_dif3, resd)
  
 
  ;plot(0)=gsn_csm_contour_map(wks, aod_dif4, resd)
  ;plot(0)=gsn_csm_contour_map(wks, aod_dif5, resd)
  plot(0)=gsn_csm_contour_map(wks, aod_dif6, resd)
;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

  shp1="/home/user/chensy3/csr4/chenyu/NCL/china/mygeodata/china.shp"
  lnres1        = True
  lnres1@gsLineColor      ="black"
  lnres1@gsLineThicknessF = 1.5          ; 2x thickness
  shp_plot1     = gsn_add_shapefile_polylines(wks,plot(0),shp1,lnres1)

pnlres                            = True
pnlres@gsnPanelFigureStringsFontHeightF =0.03;0.015;
pnlres@lbLabelFontHeightF=0.03;0.02;
pnlres@gsnPanelFigureStrings=(/"e"/);,"e"(/"MISR","MODIS","DYN","STA"/);(/"c","d"/);,"a","b","c","d","e"
pnlres@amJust               = "topLeft"
;pnlres@gsnPanelLabelBar=True
pnlres@lbBoxSeparatorLinesOn=False
;pnlres@lbOrientation="vertical"
gsn_panel(wks,(/plot/),(/1,1/),pnlres)

end
exit